/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.table;

import filenet.vw.api.VWParticipant;
import filenet.vw.toolkit.utils.images.VWImageLoader;
import filenet.vw.toolkit.utils.table.VWParticipantItem;
import filenet.vw.toolkit.utils.uicontrols.security.VWParticipantLabel;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class VWParticipantListCellRenderer
extends VWParticipantLabel
implements ListCellRenderer {
    protected ImageIcon m_userIcon = null;
    protected ImageIcon m_groupIcon = null;
    protected ImageIcon m_wflGroupIcon = null;
    protected ImageIcon m_unknownIcon = null;

    public VWParticipantListCellRenderer() {
        this.setOpaque(true);
        this.m_userIcon = VWImageLoader.createImageIcon("user.gif");
        this.m_groupIcon = VWImageLoader.createImageIcon("group.gif");
        this.m_wflGroupIcon = VWImageLoader.createImageIcon("wflgroup.gif");
        this.m_unknownIcon = VWImageLoader.createImageIcon("question.gif");
    }

    public void releaseReferences() {
        super.releaseReferences();
        this.m_userIcon = null;
        this.m_groupIcon = null;
        this.m_wflGroupIcon = null;
        this.m_unknownIcon = null;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.setFont(list.getFont());
        this.setEnabled(list.isEnabled());
        this.setComponentOrientation(list.getComponentOrientation());
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        if (value == null) {
            this.setIcon(this.m_unknownIcon);
            this.setText(null);
            this.setToolTipText(null);
        } else if (value instanceof VWParticipantItem) {
            VWParticipantItem pItem = (VWParticipantItem)value;
            switch (pItem.getType()) {
                case 0: {
                    this.setIcon(this.m_userIcon);
                    break;
                }
                case 1: {
                    this.setIcon(this.m_groupIcon);
                    break;
                }
                case 2: {
                    this.setIcon(this.m_wflGroupIcon);
                    break;
                }
                case 4: {
                    this.setIcon(this.m_unknownIcon);
                    break;
                }
                default: {
                    this.setIcon(null);
                }
            }
            String name = pItem.getDisplayName();
            if (name != null && name.length() > 0 && name.charAt(0) == '\"') {
                name = name.substring(1, name.length() - 1);
            }
            this.setText(name);
            this.setVWParticipant(pItem.getVWParticipant());
        } else if (value instanceof VWParticipant) {
            VWParticipant vwParticipant = (VWParticipant)value;
            this.setIcon(null);
            String name = vwParticipant.getParticipantName();
            if (name != null && name.length() > 0 && name.charAt(0) == '\"') {
                name = name.substring(1, name.length() - 1);
            }
            this.setText(name);
            this.setVWParticipant(vwParticipant);
        } else if (value instanceof String) {
            this.setIcon(this.m_unknownIcon);
            this.setText((String)value);
            this.setToolTipText(null);
        }
        return this;
    }
}

